/*
 * Decompiled with CFR 0.152.
 */
package cds.moc;

import cds.moc.Moc;
import cds.moc.Moc1D;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.InputMismatchException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FMoc
extends Moc1D {
    public static final double DAYMICROSEC = 8.64E10;
    public static final int MAXORD_F = 59;
    public static final int FACT_F = 2;
    public static final char DIM_F = 'f';
    public static final long NBVAL_F = FMoc.pow2(59L);
    public static final String SYS_F = "FREQUENCY";
    static final long F64_EXPONENT_BIT_MASK = 0x7FF0000000000000L;
    static final long F64_BUT_EXPONENT_BIT_MASK = -9218868437227405313L;
    public static final double FREQ_MIN = (double)5.04871E-29f;
    public static final double FREQ_MAX = 5.846006549323611E48;
    public static final long LMIN = FMoc.getHash1(5.04871E-29f);
    public static final long LMAX = FMoc.getHash1(5.846006549323611E48);

    @Override
    public final int maxOrder() {
        return 59;
    }

    @Override
    public final int shiftOrder() {
        return 1;
    }

    @Override
    public final char cDim() {
        return 'f';
    }

    @Override
    public final long maxVal() {
        return NBVAL_F;
    }

    @Override
    public final String sys() {
        return SYS_F;
    }

    public FMoc() {
    }

    public FMoc(int mocOrder) {
        super(mocOrder);
    }

    public FMoc(String s) throws Exception {
        super(s);
    }

    public FMoc(FMoc moc) throws Exception {
        super(moc);
    }

    public FMoc(InputStream in) throws Exception {
        super(in);
    }

    @Override
    public FMoc clone() throws CloneNotSupportedException {
        FMoc moc = this.dup();
        this.clone1(moc);
        return moc;
    }

    @Override
    protected void clone1(Moc moc) throws CloneNotSupportedException {
        if (!(moc instanceof FMoc)) {
            throw new CloneNotSupportedException("Uncompatible type of MOC for clone. Must be TMoc");
        }
        super.clone1(moc);
    }

    @Override
    public FMoc dup() {
        FMoc moc = new FMoc();
        moc.sys = this.sys;
        return moc;
    }

    @Override
    public int sizeOfCoding() {
        return 8;
    }

    @Override
    public int getNbCoding() {
        return this.range.sz;
    }

    @Override
    public void add(Moc moc) throws Exception {
        if (!(moc instanceof FMoc)) {
            throw new Exception("Uncompatible Moc for adding");
        }
        super.add(moc);
    }

    @Override
    public String getTimeSys() {
        return SYS_F;
    }

    public static long getHash(double freq) throws Exception {
        if (freq < (double)5.04871E-29f || freq > 5.846006549323611E48) {
            throw new Exception("Frequency outside [5.0487097934144756E-29 .. 5.846006549323611E48]");
        }
        return FMoc.getHash1(freq);
    }

    public static long getHash1(double freq) {
        long freq_bits = Double.doubleToLongBits(freq);
        long exponent = (freq_bits & 0x7FF0000000000000L) >>> 52;
        exponent = exponent - 929L << 52;
        long hash = freq_bits & 0x800FFFFFFFFFFFFFL | exponent;
        return hash;
    }

    public static double getFreq(long hash) throws Exception {
        if (hash < LMIN || hash > LMAX) {
            throw new Exception("hash frequency outside [" + LMIN + " .. " + LMAX + "]");
        }
        return FMoc.getFreq1(hash);
    }

    public static double getFreq1(long hash) {
        long exponent = (hash & 0x7FF0000000000000L) >> 52;
        exponent = exponent + 929L << 52;
        long freqBits = hash & 0x800FFFFFFFFFFFFFL | exponent;
        double freq = Double.longBitsToDouble(freqBits);
        return freq;
    }

    public void add(double freqMin, double freqMax) throws Exception {
        this.add(59, FMoc.getHash(freqMin), FMoc.getHash(freqMax));
    }

    public boolean contains(double freq) throws Exception {
        return this.range.contains(FMoc.getHash(freq));
    }

    public double getFreqMin() {
        if (this.isEmpty()) {
            return -1.0;
        }
        return FMoc.getFreq1(this.range.begins(0));
    }

    public double getFreqMax() {
        if (this.isEmpty()) {
            return -1.0;
        }
        return FMoc.getFreq1(this.range.ends(this.range.nranges() - 1));
    }

    public static double getFreq(int order, long val) throws Exception {
        int shift = 59 - order;
        long t = val << shift;
        return FMoc.getFreq(t);
    }

    public Iterator<long[]> jdIterator(double freqStart, double freqStop) throws Exception {
        if (freqStart > freqStop) {
            throw new InputMismatchException();
        }
        return new JDIterator(FMoc.getHash(freqStart), FMoc.getHash(freqStop));
    }

    @Override
    public boolean isIncluding(Moc moc) throws Exception {
        if (!(moc instanceof FMoc)) {
            throw new Exception("Uncompatible Moc type for FMoc isIncluding test");
        }
        this.flush();
        return this.range.contains(((FMoc)moc).range);
    }

    @Override
    public boolean isIntersecting(Moc moc) throws Exception {
        if (!(moc instanceof FMoc)) {
            throw new Exception("Uncompatible Moc type for FMoc isIntersecting test");
        }
        this.flush();
        return this.range.overlaps(((FMoc)moc).range);
    }

    @Override
    public FMoc union(Moc moc) throws Exception {
        if (!(moc instanceof FMoc)) {
            throw new Exception("Uncompatible Moc type for FMoc union");
        }
        return (FMoc)super.union(moc);
    }

    @Override
    public FMoc intersection(Moc moc) throws Exception {
        if (!(moc instanceof FMoc)) {
            throw new Exception("Uncompatible Moc type for FMoc subtraction");
        }
        return (FMoc)super.subtraction(moc);
    }

    @Override
    public FMoc subtraction(Moc moc) throws Exception {
        if (!(moc instanceof FMoc)) {
            throw new Exception("Uncompatible Moc type for FMoc subtraction");
        }
        return (FMoc)super.subtraction(moc);
    }

    @Override
    public FMoc complement() throws Exception {
        return (FMoc)super.complement();
    }

    @Override
    protected void readSpecificData(InputStream in, int naxis1, int naxis2, int nbyte, Moc.HeaderFits header) throws Exception {
        int mocOrder = -1;
        try {
            mocOrder = header.getIntFromHeader("MOCORD_F");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (mocOrder == -1) {
            throw new Exception("Missing MOC order in FITS header (MOCORD_F)");
        }
        this.readSpecificDataRange(in, naxis1, naxis2, nbyte);
        this.setMocOrder(mocOrder);
    }

    @Override
    protected int writeSpecificFitsProp(OutputStream out) throws Exception {
        int n = 0;
        out.write(FMoc.getFitsLine("MOCDIM", SYS_F, "Physical dimension"));
        n += 80;
        out.write(FMoc.getFitsLine("ORDERING", "RANGE", "Coding method"));
        n += 80;
        out.write(FMoc.getFitsLine("MOCORD_F", "" + this.getMocOrder(), "Frequence MOC resolution (best order)"));
        return n += 80;
    }

    class JDIterator
    implements Iterator<long[]> {
        int pos;
        int endpos;

        JDIterator(long start, long end) {
            this.pos = FMoc.this.range.indexOf(start) / 2;
            if (this.pos < 0) {
                this.pos = 0;
            }
            this.endpos = FMoc.this.range.indexOf(end) / 2 + 1;
        }

        @Override
        public boolean hasNext() {
            return FMoc.this.range.sz > 0 && this.pos < this.endpos;
        }

        @Override
        public long[] next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            long[] ret = new long[]{FMoc.this.range.begins(this.pos), FMoc.this.range.ends(this.pos)};
            ++this.pos;
            return ret;
        }

        @Override
        public void remove() {
        }
    }
}

